<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('support_code', 'name', 'organization', 'country_id', 'address', 'telephone', 'activity_id', 'know_us_from', 'email', 'password', 'rememberToken');

    public function country()
    {
        return $this->belongsTo('App\Models\Country');
    }

    public function subscribtions()
    {
        return $this->hasMany('App\Models\Subscription');
    }

    public function clientPayments()
    {
        return $this->hasMany('App\Models\ClientPayment');
    }

    public function ticketReplies()
    {
        return $this->hasMany('App\Models\TicketReplay');
    }

    public function tickets()
    {
        return $this->hasMany('App\Models\Ticket');
    }

    public function advertisementClients()
    {
        return $this->hasMany('App\Models\AdvertisementClient');
    }

    public function activity()
    {
        return $this->belongsTo('App\Models\Activity');
    }

}